<%
Class Database_Class
  Private m_connection
  Private m_connection_string

  
  '---------------------------------------------------------------------------------------------------------------------
  Public Sub Initialize(connection_string)
    m_connection_string = connection_string
    'force a reconnect using the new connection string on the next call
    set m_connection = Nothing
  End Sub
  
  Public Property Get ConnectionString
    ConnectionString = m_connection_string
  End Property

  '---------------------------------------------------------------------------------------------------------------------
  Public Function Query(sql, params)
on error resume next
    dim i
    dim cmd : set cmd = server.createobject("adodb.command")
    set cmd.ActiveConnection = Connection()
    cmd.CommandText = sql
   
    dim rs

   if WRAP_DEBUG=1 then  Response.write "<p>Query: " & stripHTML(sql) 

    If IsArray(params) then
	  if WRAP_DEBUG=1 then
		for i=0 to ubound(params)
	   		Response.write  stripHTML(params(i)) & ", "	
		next
		End If
      set rs = cmd.Execute(, params)
    ElseIf Not IsEmpty(params) then  ' one parameter
	  if WRAP_DEBUG=1 then  Response.write "Parameter=" & params
      set rs = cmd.Execute(, Array(params))
    Else
      set rs = cmd.Execute()
    End If
  if Err.Number <> 0 then ReportError  "CAT Error Reported", sql  & " <p>URL=" &REquest.ServerVariables("SCRIPT_NAME")& "<p>Error Description: " & Err.Description
    set Query = rs
  End Function
  
  '---------------------------------------------------------------------------------------------------------------------
  Public Function PagedQuery(sql, params, per_page, page_num, ByRef page_count, ByRef record_count)
  on error resume next
    dim cmd : set cmd = server.createobject("adodb.command")
    set cmd.ActiveConnection = Connection
    cmd.CommandText = sql
    
    cmd.CommandType = 1                                   'adCmdText
    cmd.ActiveConnection.CursorLocation = 3               'adUseClient
    
    dim rs
    if WRAP_DEBUG=1 then Response.write "<p>PageQuery" & sql 
    If IsArray(params) then
      for i=0 to ubound(params)
	  if WRAP_DEBUG=1 then Response.write params(i) & ", "	
		if VarType(params(i)) = vbString then params(i) = strip_tags(params(i))
	next
	  set rs = cmd.Execute(, params)
	  
    ElseIf Not IsEmpty(params) then  ' one parameter
      set rs = cmd.Execute(, Array(params))
    Else
      set rs = cmd.Execute()
    End If
    
    If Not rs.EOF and Not (IsEmpty(per_page) and IsEmpty(page_num) and IsEmpty(page_count) and IsEmpty(record_count)) then
      
      'make paged query
      rs.MoveFirst
      rs.PageSize     = per_page
      rs.AbsolutePage = page_num
      page_count      = rs.PageCount
      record_count    = rs.RecordCount
      
    Else
      per_page      = rs.RecordCount
      record_count  = rs.RecordCount
    End If
     if Err.Number <> 0 then ReportError  "CAT Error Reported", sql & " <p>URL=" &REquest.ServerVariables("SCRIPT_NAME") & "<p>Error Description: " & Err.Description
    set PagedQuery = rs
  End Function
  
  '---------------------------------------------------------------------------------------------------------------------
  Public Sub Execute(sql, params)
    me.query sql, params
  End Sub
  
  '---------------------------------------------------------------------------------------------------------------------
  Public Sub BeginTransaction
    Connection.BeginTrans
  End Sub
  
  Public Sub RollbackTransaction
    Connection.RollbackTrans
  End Sub
  
  Public Sub CommitTransaction
    Connection.CommitTrans
  End Sub
  
  '---------------------------------------------------------------------------------------------------------------------
  ' Private Methods
  '---------------------------------------------------------------------------------------------------------------------
  Private Sub Class_terminate
    Destroy m_connection
  End Sub
  
  Private Sub Destroy(obj)
    On Error Resume Next
      obj.Close
    On Error Goto 0
    Set obj = Nothing
  End Sub
  
  Private Function Connection
    If IsEmpty(m_connection) then
      If IsEmpty(m_connection_string) then Err.Raise 1, "lib.Data:Connection", "empty connection string"
      set m_connection = Server.CreateObject("adodb.connection")
      m_connection.open m_connection_string
    ElseIf IsObject(m_connection) then
      If m_connection is Nothing then
        set m_connection = Server.CreateObject("adodb.connection")
        m_connection.open m_connection_string
      End If
    Else
    End If
    set Connection = m_connection
  End Function


' Strip HTML/ASP/PHP tags from a string.
  
  Private Function strip_tags(strHTML)
 set objRegExp = new RegExp
	' Only allow some tags
    objRegExp.Pattern = "<^((b)|(li)|(br))>.*</.*>"
    objRegExp.IgnoreCase = varIgnoreCase
    objRegExp.Global = True
strHTML = objRegExp.replace(strHTML, "")
set objRegExp= nothing
 	strip_tags = strHTML
End Function
	
  Private Function ReportError(Subject, MsgHTML)
  
  ' Function to notify dev
	Set myMail=CreateObject("CDO.Message")
	myMail.Subject=Subject
	myMail.From="Hung Nguyen <email address>"
	myMail.To="Hung Nguyen <email address>"
	myMail.HTMLBody=MsgHTML
	myMail.Configuration.Fields.Item _
("http://schemas.microsoft.com/cdo/configuration/sendusing")=2
'Name or IP of remote SMTP server
myMail.Configuration.Fields.Item _
("http://schemas.microsoft.com/cdo/configuration/smtpserver") _
="smtp.DNS   "
'Server port
myMail.Configuration.Fields.Item _
("http://schemas.microsoft.com/cdo/configuration/smtpserverport") _
=25 
myMail.Configuration.Fields.Update

	myMail.Send
	set myMail=nothing
	ReportError= 1
	'Response.write MsgHTML
	'Response.End()
  End Function

	
end Class
%>
